' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports Microsoft.VisualBasic

Public Class AppConfiguration

  ''' <summary>
  ''' Zwraca acuch poczenia dla aplikacji WitrynaPomocy.
  ''' </summary>
  Public Shared ReadOnly Property ConnectionString() As String
    Get
      Dim tempValue As String = "server=(local)\SqlExpress;AttachDbFileName=|DataDirectory|CustomerSupport.mdf;Integrated Security=true;User Instance=true"
      Try
        If ConfigurationManager.ConnectionStrings("CustomerSupport") IsNot Nothing Then
          tempValue = ConfigurationManager.ConnectionStrings("CustomerSupport").ConnectionString
        End If
      Catch
        ' Jeli nie moemy pobra ustawienia z pliku konfiguracyjnego, ignoruj bd i zwr 
        ' domylny acuch poczenia wskazujcy na instancj SqlExpress na lokalnym 
        ' komputerze i sprbuj doczy baz danych CustomerSupport automatycznie.
      End Try
      Return tempValue
    End Get
  End Property

  ''' <summary>
  ''' Zwraca miejsce, w ktrym zapisywane s przesane na serwer pliki. Aby uatwi obsug
  ''' uywamy tego samego miejsca, co FCKeditor.
  ''' </summary>
  Public Shared ReadOnly Property UploadFolder() As String
    Get
      Dim tempValue As String = "/WitrynaPomocy/UserFiles/Products/"
      Try
        If ConfigurationManager.ConnectionStrings("FCKeditor:UserFilesPath") IsNot Nothing Then
          tempValue = ConfigurationManager.AppSettings.Get("FCKeditor:UserFilesPath")
        End If
      Catch
        ' Jesli nie moemy pobra ustawienia z pliku konfiguracyjnego, zignoruj bd i zwr
        ' domyln nazw folderu. 
      End Try
      Return tempValue
    End Get
  End Property

  ''' <summary>
  ''' Zwraca domylny opis witryny.
  ''' </summary>
  Public Shared ReadOnly Property DefaultSiteDescription() As String
    Get
      Dim tempValue As String = "Wrox Komputery - Numer jeden wrd sklepw komputerowych na wiecie"
      Try
        If ConfigurationManager.ConnectionStrings("DefaultSiteDescription") IsNot Nothing Then
          tempValue = ConfigurationManager.AppSettings.Get("DefaultSiteDescription")
        End If
      Catch
        ' Jesli nie moemy pobra ustawienia z pliku konfiguracyjnego, zignoruj bd i zwr
        ' domylny opis. 
      End Try
      Return tempValue
    End Get
  End Property

End Class
